// Graphical SimpleListDemo Demonstration
// Written by Josh K. Helzer
// Monday, October 22, 2001
//
// Modified by Chuck Cusack, October 24, 2001

import java.applet.*;
import aLibrary.*;
import javax.swing.*;

public class SimpleListDemo extends Applet {
    private AWindow canvas;
    private ListButton[] lb = new ListButton[7];
    private MyList theList;
    private ListView theLV;
    private ATextField inputArea,outputArea;
//------------------------------------------------------------------------------
    public SimpleListDemo() {}
//------------------------------------------------------------------------------
    public void start() {
        initialize();
    }
//------------------------------------------------------------------------------
    private void initialize() {
        // Create list
        theList = new MyList();

        // Create window
        canvas = new AWindow(0,0,800,250);
        //jCheckBox1.setText("jCheckBox1");
        canvas.setTitle("Graphical SimpleListDemo Demonstration");

        // Create buttons
        for(int i=0; i<4; i++) {
            lb[i] = new ListButton(125*i+50,150,100,25,this,i);
            lb[i].place(canvas);
        }
        lb[0].setText("start()");
        lb[1].setText("forth()");
        lb[2].setText("remove()");
        lb[3].setText("insert()");

        // Create more buttons
        for(int i=0; i<3; i++) {
            lb[i+4] = new ListButton(125*(i+1)+50,200,100,25,this,i+4);
            lb[i+4].place(canvas);
        }
        lb[4].setText("count()");
        lb[5].setText("item()");
        lb[6].setText("isOff()");
        outputArea=new ATextField(125*5,200,100,25);
        outputArea.setFontSize(16);
        outputArea.place(canvas);

        ALabel outLabel=new ALabel(125*4+40,200,100,25);
        outLabel.setText("output: ");
        outLabel.setFontSize(16);
        outLabel.place(canvas);

        inputArea=new ATextField(125*5,150,100,25);
        inputArea.setFontSize(16);
        inputArea.place(canvas);
        ALabel inLabel=new ALabel(125*4+40,150,100,25);
        inLabel.setText("input: ");
        inLabel.setFontSize(16);
        inLabel.place(canvas);

        ALabel title=new ALabel(150,100,500,25);
        title.setText("SimpleListDemo Demonstration");
        title.setFontSize(24);
        title.place(canvas);

        // Create initial list view
        theLV = new ListView(theList);
        theLV.place(canvas);
        canvas.repaint();
    //jTextPane1.setText("jTextPane1");
    //this.add(jCheckBox1, null);
    //this.add(jTextPane1, null);

    }
//------------------------------------------------------------------------------
    public void clickedAction(int id) {
        switch(id) {
            // start()
            case 0:
                theList.start();
                break;

            // forth()
            case 1:
                theList.forth();
                break;

            // insert()
            case 3:
                if(theList.count()!=10) {
                    theList.insert(inputArea.getText());
                }
                break;

            // remove()
            case 2:
                theList.remove();
                break;
            case 4:
                outputArea.setText(""+theList.count());
                break;
            case 5:
                Object A=theList.item();

                if(A instanceof String) {
                  outputArea.setText((String) A);
                }
                else {
                   outputArea.setText("null");
                }
                break;
            case 6:
                outputArea.setText(""+theList.isOff());
                break;
        }
        // Update theLV (list view)
        theLV.remove();
        theLV = new ListView(theList);
        theLV.place(canvas);
        canvas.repaint();
    }
}
