/*
 * Decompiled with CFR 0.152.
 */
package SortingDemo;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class SortingDemo
extends JApplet {
    int[] randList;
    int[] sSortList;
    int[] qSortList;
    JTextField randSize = new JTextField(2);
    JTextArea randInput = new JTextArea(1, 60);
    JTextArea qSortOutput = new JTextArea(1, 60);
    JTextArea sSortOutput = new JTextArea(1, 60);

    @Override
    public void init() {
        JLabel sizeLabel = new JLabel("List size:");
        JButton randButton = new JButton("Random List");
        this.randInput.setBorder(new CompoundBorder(new LineBorder(Color.GRAY, 4), new LineBorder(Color.BLACK)));
        this.randInput.setEditable(false);
        Box randBox = Box.createHorizontalBox();
        randBox.add(sizeLabel);
        randBox.add(Box.createHorizontalStrut(10));
        randBox.add(this.randSize);
        randBox.add(Box.createHorizontalStrut(10));
        randBox.add(randButton);
        randBox.add(Box.createHorizontalStrut(10));
        randBox.add(this.randInput);
        JButton sSortButton = new JButton("Insertion Sort");
        this.sSortOutput.setEditable(false);
        this.sSortOutput.setBorder(new CompoundBorder(new LineBorder(Color.ORANGE, 4), new LineBorder(Color.blue, 3)));
        Box sSortBox = Box.createHorizontalBox();
        sSortBox.add(Box.createHorizontalStrut(20));
        sSortBox.add(sSortButton);
        sSortBox.add(Box.createHorizontalStrut(10));
        sSortBox.add(this.sSortOutput);
        sSortBox.add(Box.createHorizontalStrut(5));
        JButton qSortButton = new JButton("QuickSort");
        this.qSortOutput.setEditable(false);
        this.qSortOutput.setBorder(new CompoundBorder(new LineBorder(Color.BLUE, 4), new LineBorder(Color.ORANGE, 3)));
        Box qSortBox = Box.createHorizontalBox();
        qSortBox.add(Box.createHorizontalStrut(20));
        qSortBox.add(qSortButton);
        qSortBox.add(Box.createHorizontalStrut(10));
        qSortBox.add(this.qSortOutput);
        qSortBox.add(Box.createHorizontalStrut(5));
        Box middleBox = Box.createVerticalBox();
        middleBox.add(randBox);
        middleBox.add(sSortBox);
        middleBox.add(qSortBox);
        JButton clearButton = new JButton("Clear All");
        Box clearBox = Box.createHorizontalBox();
        clearBox.add(Box.createHorizontalGlue());
        clearBox.add(clearButton);
        clearBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)middleBox, "Center");
        this.getContentPane().add((Component)clearBox, "South");
        randButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size;
                SortingDemo.this.clearStuff();
                try {
                    size = Integer.parseInt(SortingDemo.this.randSize.getText());
                }
                catch (NumberFormatException f) {
                    size = 1;
                }
                SortingDemo.this.randList(size);
                SortingDemo.this.showList(SortingDemo.this.randList, SortingDemo.this.randInput);
            }
        });
        sSortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortingDemo.this.sSortList = SortingDemo.this.sortList(SortingDemo.this.randList);
                SortingDemo.this.showList(SortingDemo.this.sSortList, SortingDemo.this.sSortOutput);
            }
        });
        qSortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortingDemo.this.qSortList = SortingDemo.this.qSort(SortingDemo.this.randList);
                SortingDemo.this.showList(SortingDemo.this.qSortList, SortingDemo.this.qSortOutput);
            }
        });
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortingDemo.this.clearStuff();
            }
        });
    }

    void showList(int[] list, JTextArea area) {
        area.setText("");
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i] < 10) {
                    area.append(" " + list[i] + " ");
                } else {
                    area.append(String.valueOf(list[i]) + " ");
                }
                ++i;
            }
        }
    }

    void clearStuff() {
        this.randInput.setText("");
        this.sSortOutput.setText("");
        this.qSortOutput.setText("");
        System.out.println("cleared");
    }

    int[] sortList(int[] inputArray) {
        int[] outputArray = new int[inputArray.length];
        outputArray[0] = inputArray[0];
        int i = 1;
        while (i < inputArray.length) {
            int j = i - 1;
            while (j >= 0 && outputArray[j] > inputArray[i]) {
                outputArray[j + 1] = outputArray[j];
                --j;
            }
            outputArray[j + 1] = inputArray[i];
            ++i;
        }
        return outputArray;
    }

    int[] qSort(int[] inputArray) {
        int[] outputArray = new int[inputArray.length];
        int i = 0;
        while (i < inputArray.length) {
            outputArray[i] = inputArray[i];
            ++i;
        }
        this.quickSort(outputArray, 0, outputArray.length - 1);
        return outputArray;
    }

    void quickSort(int[] inputArray, int first, int last) {
        if (first < last) {
            int pivot = this.partition(inputArray, first, last);
            this.quickSort(inputArray, first, pivot - 1);
            this.quickSort(inputArray, pivot + 1, last);
        }
    }

    int partition(int[] inputArray, int first, int last) {
        int thePivot = inputArray[first];
        int i = first + 1;
        int j = last;
        int empty = first;
        while (true) {
            if (i <= last && inputArray[i] < thePivot) {
                ++i;
                continue;
            }
            while (j >= first && inputArray[j] > thePivot) {
                --j;
            }
            if (i >= j) break;
            inputArray[empty] = inputArray[j];
            inputArray[j] = inputArray[i];
            empty = i++;
            --j;
        }
        if (j >= empty) {
            inputArray[empty] = inputArray[j];
            inputArray[j] = thePivot;
        } else {
            inputArray[empty] = thePivot;
            j = empty;
        }
        return j;
    }

    void randList(int length) {
        this.randList = new int[length];
        int i = 0;
        while (i < length) {
            this.randList[i] = (int)(Math.random() * 100.0);
            ++i;
        }
    }
}

