import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;

public class SwingExampleApp {

   public static void main(String[] args) {
 
      //------------------------------------------------------------------
      // A Plain-Jane label.
      //
      JLabel theLabel=new JLabel("This label Doesn't serve much purpose");

      theLabel.setBorder(new EmptyBorder(10,10,20,20));

      //------------------------------------------------------------------
      // A label that listens for MouseEvents.  It is an extension of
      // JLabel that implements MouseListener.
      //
      MouseLabel mouseLabel=new MouseLabel();

      mouseLabel.setBorder(new MatteBorder(5,5,5,5,Color.green));
 
      //------------------------------------------------------------------
      // A special label class to implement MouseMotionListener
      //
      class MLabel extends JLabel implements MouseMotionListener {
         MLabel() {
         }
         public void mouseDragged(MouseEvent e) {
                setText("Help: I'm Being Dragged");
                 }
         public void mouseMoved(MouseEvent e) {
                 setText("Coordinates: "+e.getX()+","+e.getY());
                 }
          };  

      MLabel anotherLabel=new MLabel();
      anotherLabel.setText("Waiting for the mouse to enter....");

      // Although the class for this object implements MouseMotionListener,
      // nowhere in the class is a listener registered.
      // Therefore we have to add a listener, the same object.  weird.
      //
      anotherLabel.addMouseMotionListener(anotherLabel);

      anotherLabel.setBorder(
           new CompoundBorder(
                new TitledBorder(new EmptyBorder(2,2,2,2),"Look: Coordinates.",
                                TitledBorder.CENTER, TitledBorder.BOTTOM),
                new LineBorder(new Color(200,200,0),4)
                ));

      //------------------------------------------------------------------
      // A new label that does the same as the previous label, but the
      // event handling is done differently
      //
      final JLabel fourthLabel=new JLabel();
         // Since I am accessing fourthLabel from within an 
         // (anonymous) inner class (below), it has to be final.
         //

      fourthLabel.setText("blah            ");

      fourthLabel.addMouseMotionListener(new MouseMotionListener() {
         public void mouseDragged(MouseEvent e) {
                fourthLabel.setText("Help: I'm Being Dragged");
                 }
         public void mouseMoved(MouseEvent e) {
                 fourthLabel.setText("Coordinates: "+e.getX()+","+e.getY());
                 }
    
      });

      fourthLabel.setBorder(
           new SoftBevelBorder(BevelBorder.RAISED,Color.red,Color.blue));
      //------------------------------------------------------------------
      // A box to put labels on
      //
      Box labelBox=Box.createVerticalBox();

      // Add the labels to a box
      labelBox.add(theLabel);
      labelBox.add(mouseLabel);
      labelBox.add(anotherLabel);
      labelBox.add(fourthLabel);

      //------------------------------------------------------------------
      // A button to demonstrate actionListener
      //
      JButton someButton=new JButton("Press me");

      // mouseLabel wants to listen for events from someButton.
      someButton.addActionListener(mouseLabel);
    
      //------------------------------------------------------------------
      // An exit button
      //
      JButton anotherButton=new JButton("don't press me");
      anotherButton.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
                 System.exit(0);
                 }
          });  

      //------------------------------------------------------------------
      // A box to put the buttons on.
      //
      Box buttonBox=Box.createVerticalBox();
      buttonBox.add(someButton);
      buttonBox.add(anotherButton);

      //------------------------------------------------------------------
      // set up the main JFrame, put stuff on it, pack it, show it.
      //
      JFrame window=new JFrame("Nothing");
      window.getContentPane().setLayout(new BorderLayout());

      window.getContentPane().add(buttonBox,BorderLayout.EAST);

      window.getContentPane().add(labelBox,BorderLayout.CENTER);

      window.pack();
      window.show();
      //------------------------------------------------------------------

   }
}
