import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/**
 * PictureApplet draws a picture in an applet
 */
public class PictureApplet extends JApplet
{

    /**
     * In applets, the init method is where things get set up.
     * This is the only method that is needed if it is run as
     * an applet in a webpage.
     */
    public void init() 
    {
	   add(new PicturePanel());
    }

    /**
     * The default constructor.  In this case, we don't want it
     * to do anything.
     */
    public PictureApplet() {
    }
    
    // The rest of the class variables and methods allow us 
    // to run this as a stand alone application.
     
    // The desired dimensions of the main window
    private int width=400;
    private int height=300;
    
     // The graphical components (Only one for this application)
    private PicturePanel mainPanel;
    
    /**
     * The main method, which allows us to run the application 
     * without using a webpage.  In other words, this is the method
     * that is called when you run a Java application. 
     */
    public static void main(String[] args) {  
        PictureApplet frame = new PictureApplet();
	frame.makeFrame();  
     }
    
    
    /**
     * Create the drawing panel and various other components
     * that we need for our program.
     */
    public void makeFrame() {
    	JFrame theFrame = new JFrame();
        theFrame.setTitle("A Picture");
	theFrame.addWindowListener (new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
        }});;
        
        // Instantiate the main drawing panel
        mainPanel=new PicturePanel();
        
        // Place all of the graphical components on the main window
        Container cont=theFrame.getContentPane();
        //cont.setLayout(new BorderLayout());
        cont.add(mainPanel,BorderLayout.CENTER);
  
        // Finish setting up the main window
        theFrame.setBackground(Color.white);
        theFrame.pack(); 
        theFrame.setSize(new Dimension(width,height));
        theFrame.setVisible(true);
    }
}
