/**
 * A simple example of how to use a swing Timer to do animation. 
 * 
 */
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class draws a picture on a panel
 * 
 * @author Your Name
 */
public class PicturePanel extends JPanel 
{
    private int x=0;
    private javax.swing.Timer myTimer;

	public PicturePanel()
	{    
	    // Create a timer object.
	    // The first parameter is the delay between firings in milliseconds.
	    // In this case, it fires every 1/10 of a second.
	    // The second parameter is the ActionListener which will respond to
	    // the event that is fired every time it goes off.
	    // This is an example of an annoymous inner class--the class is never
	    // given a name, but is an extension of ActionListener.
	    
	    myTimer=new javax.swing.Timer(100,new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // Notice that the variable x is from PicturePanel, not this class.
                x += 10;
                if(x >= getWidth()) { // Also notice getWidth is from PicturePanel
                    x=0;
                }
                repaint(); // And repaint is also from PicturePanel.
                // NOTE:  NEVER EVER call repaint from paintComponent or anything
                // that painComponent calls!  repaint() has the effect that 
                // paintComponent is called, so calling repaint will mean it 
                // keeps getting called over and over.
                // Also, never call paintComponent directly.
            }
        });
        
        // Don't forget to start the timer.  Otherwise nothing will happen.
        myTimer.start();
	}
	
	/**
	 * Method overridden so that the JPanel canvas will be painted
	 * how we want it.
	 */
	public void paintComponent(Graphics g) {
	    super.paintComponent(g);
	    
	    // Draw a rectangle
	    g.setColor(Color.blue);
	    g.fillRect(100,75,50,50);
	    
	    // Translate and draw the oval
	    g.translate(x,0); 
	    
	    g.setColor(Color.red);
	    g.fillOval(0,85,20,30); 
	    
	    // Now translate back and draw another rectangle
	    g.translate(-x,0);
	    g.setColor(Color.green);
	    g.fillRect(200,75,50,50);
	}
}
