/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.border.*;

public class VennDiagram extends JApplet {
  VennPanel vennPanel = new VennPanel();

  boolean isStandalone = false;
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel northPanel = new JPanel();
  JPanel southPanel = new JPanel();
  JPanel centerPanel = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  JComboBox aDropDown = new JComboBox();
  JComboBox bDropDown = new JComboBox();
  JPanel buttonPanel = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  JLabel aLabel = new JLabel();
  JLabel bLabel = new JLabel();
  TitledBorder titledBorder1;
  ButtonGroup buttonGroup = new ButtonGroup();
  JRadioButton intersectionButton = new JRadioButton();
  JRadioButton unionButton = new JRadioButton();
  JRadioButton differenceButton = new JRadioButton();
  JRadioButton xorButton = new JRadioButton();
  JCheckBox complementButton = new JCheckBox();
  JRadioButton noneButton = new JRadioButton();
  /**Get a parameter value*/
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  /**Construct the applet*/
  public VennDiagram() {
  }
  /**Initialize the applet*/
  public void init() {
    aDropDown.addItem("Rectangle");
    aDropDown.addItem("Ellipse");
    aDropDown.addItem("Star");
    aDropDown.addItem("Triangle");

    bDropDown.addItem("Rectangle");
    bDropDown.addItem("Ellipse");
    bDropDown.addItem("Star");
    bDropDown.addItem("Triangle");
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    FontFixer.setUIFont("Lucida Sans");
    SwingUtilities.updateComponentTreeUI(this);
  }
  /**Component initialization*/
  private void jbInit() throws Exception {
    titledBorder1 = new TitledBorder("");
    this.setSize(new Dimension(400,300));
    this.getContentPane().setLayout(borderLayout1);
    centerPanel.setBackground(Color.white);
    centerPanel.setBorder(BorderFactory.createLoweredBevelBorder());
    centerPanel.setLayout(borderLayout2);
    buttonPanel.setLayout(gridLayout1);
    gridLayout1.setRows(10);
    gridLayout1.setColumns(1);
    aDropDown.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        aDropDown_actionPerformed(e);
      }
    });
    bDropDown.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        bDropDown_actionPerformed(e);
      }
    });
    aLabel.setText("A:");
    bLabel.setText("B:");
    aDropDown.setForeground(vennPanel.shape1.getColor());
    bDropDown.setForeground(vennPanel.shape2.getColor());
    vennPanel.setBackground(new Color(124, 140, 0));
    intersectionButton.setText("A\u2229B");
    intersectionButton.setToolTipText("Intersection");
    intersectionButton.setForeground(Color.blue);
    intersectionButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    intersectionButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        intersectionButton_actionPerformed(e);
      }
    });
    unionButton.setText("A\u222AB");
    unionButton.setToolTipText("Union");
    unionButton.setForeground(Color.blue);
    unionButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    unionButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        unionButton_actionPerformed(e);
      }
    });
    differenceButton.setText("A-B");
    differenceButton.setToolTipText("Difference");
    differenceButton.setForeground(Color.blue);
    differenceButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    differenceButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        differenceButton_actionPerformed(e);
      }
    });
    xorButton.setText("A\u2295B");
    xorButton.setToolTipText("XOR");
    xorButton.setForeground(Color.blue);
    xorButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    xorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        xorButton_actionPerformed(e);
      }
    });
    complementButton.setText("Not");
    complementButton.setToolTipText("Complement");
    complementButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    complementButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        complementButton_actionPerformed(e);
      }
    });
    noneButton.setSelected(true);
    noneButton.setText("None");
    noneButton.setFont(new java.awt.Font("Arial Unicode MS", 1, 12));
    noneButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        noneButton_actionPerformed(e);
      }
    });
    this.getContentPane().add(northPanel, BorderLayout.NORTH);
    northPanel.add(aLabel, null);
    northPanel.add(aDropDown, null);
    northPanel.add(bLabel, null);
    northPanel.add(bDropDown, null);
    this.getContentPane().add(southPanel, BorderLayout.SOUTH);
    this.getContentPane().add(centerPanel, BorderLayout.CENTER);
    centerPanel.add(vennPanel, BorderLayout.CENTER);
    this.getContentPane().add(buttonPanel, BorderLayout.WEST);
    buttonPanel.add(noneButton, null);
    buttonPanel.add(intersectionButton, null);
    buttonPanel.add(unionButton, null);
    buttonPanel.add(differenceButton, null);
    buttonPanel.add(xorButton, null);
    buttonPanel.add(complementButton, null);
    buttonGroup.add(intersectionButton);
    buttonGroup.add(unionButton);
    buttonGroup.add(differenceButton);
    buttonGroup.add(xorButton);
    buttonGroup.add(noneButton);
  }
  /**Get Applet information*/
  public String getAppletInfo() {
    return "Applet Information";
  }
  /**Get parameter info*/
  public String[][] getParameterInfo() {
    return null;
  }

  //static initializer for setting look & feel
  static {
    try {
      //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }
    catch(Exception e) {
    }
  }

  void noneButton_actionPerformed(ActionEvent e) {
    vennPanel.setOperation(VennPanel.NONE);
  }

  void intersectionButton_actionPerformed(ActionEvent e) {
    vennPanel.setOperation(VennPanel.INTERSECTION);
  }

  void unionButton_actionPerformed(ActionEvent e) {
    vennPanel.setOperation(VennPanel.UNION);
  }

  void differenceButton_actionPerformed(ActionEvent e) {
    vennPanel.setOperation(VennPanel.DIFFERENCE);
  }

  void xorButton_actionPerformed(ActionEvent e) {
    vennPanel.setOperation(VennPanel.XOR);
  }

  void aDropDown_actionPerformed(ActionEvent e) {
    vennPanel.shape1.setType(aDropDown.getSelectedIndex());
    vennPanel.repaint();
  }

  void bDropDown_actionPerformed(ActionEvent e) {
    vennPanel.shape2.setType(bDropDown.getSelectedIndex());
    vennPanel.repaint();
  }

  void complementButton_actionPerformed(ActionEvent e) {
    if(complementButton.isSelected())
      vennPanel.complement = true;
    else
      vennPanel.complement = false;
    vennPanel.repaint();
  }

}
