import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.applet.*;
import javax.swing.*;


/**
 * A panel that draws some set operations using Venn Diagrams
 *
 * @author Cory Lueninghoener <cluening@cse.unl.edu>
 */

public class VennPanel extends JPanel{
  public static final int NONE = 0, MOVING = 1;
  public static final int INTERSECTION = 1, UNION = 2, DIFFERENCE = 3, XOR = 4;
  boolean complement = false;
  int offsetX = 0;
  int offsetY = 0;
  VennShape curShape;
  int state = NONE;
  int operation = NONE;

  VennShape shape1 = new VennShape(VennShape.RECTANGLE, 50, 100, 75, 75);
  VennShape shape2 = new VennShape(VennShape.RECTANGLE, 150, 100, 75, 75);

  /**
   * Constructor.  Constructs.
   */
  public VennPanel() {
    shape1.setColor(new Color(0, 200, 0));
    shape2.setColor(Color.red);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Paints all of the tasty goodness that is currently in the diagram
   * @param g A Graphics context.
   */
  public void paint(Graphics g){
    Graphics2D g2d = (Graphics2D)g;
    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Color fg3D = Color.blue;
    Dimension d = getSize();
    //System.out.println(""+ d.width + "x" + d.height);

    super.paint(g);

    g2d.setPaint(Color.white);
    //g2d.setPaint(new GradientPaint(0, 0, Color.white, d.width, d.height, Color.blue));

    BufferedImage bi = new BufferedImage(7, 7, BufferedImage.TYPE_INT_RGB);
    Graphics2D big = bi.createGraphics();
    big.setColor(Color.lightGray);
    big.fillRect(0, 0, 7, 7);
    big.setColor(Color.gray);
    big.drawLine(0, 6, 6, 0);
    big.setColor(Color.white);
    big.drawLine(1, 6, 6, 1);
    big.drawLine(0, 0, 0, 0);

//    big.fillOval(0, 0, 5, 5);
    Rectangle r = new Rectangle(0,0,7,7);
    g2d.setPaint(new TexturePaint(bi, r));

    g2d.fill(new Rectangle2D.Double(0, 0, d.width, d.height));

    drawShapeFill(g2d);
    drawArea(g2d);
    drawShapeOutline(g2d);
  }

  /**
   * Draws the outlines on the two shapes
   */
  private void drawShapeOutline(Graphics2D g2d){
    Dimension d = getSize();
    g2d.setPaint(shape1.getColor());
    g2d.draw(shape1.path);

    g2d.setPaint(shape2.getColor());
    g2d.draw(shape2.path);
  }

  /**
   * Draws the fill color of the two shapes
   */
  private void drawShapeFill(Graphics2D g2d){
    Dimension d = getSize();
    g2d.setPaint(new Color(shape1.getColor().getRed(), shape1.getColor().getGreen(), shape1.getColor().getBlue(), 100));
    g2d.fill(shape1.path);

    g2d.setPaint(new Color(shape2.getColor().getRed(), shape2.getColor().getGreen(), shape2.getColor().getBlue(), 100));
    g2d.fill(shape2.path);
  }

/**
 * Draws an area
 */
  private void drawArea(Graphics2D g2d){
    Dimension d = getSize();
    Area area1 = new Area(shape1.path);
    g2d.setPaint(Color.blue);
    if(operation == INTERSECTION){
      area1.intersect(new Area(shape2.path));
    }
    else if(operation == UNION){
      area1.add(new Area(shape2.path));
    }
    else if(operation == DIFFERENCE){
      area1.subtract(new Area(shape2.path));
    }
    else if(operation == XOR){
      area1.exclusiveOr(new Area(shape2.path));
    }

    if(complement){
      Area complementArea = new Area(new Rectangle2D.Double(0, 0, d.width, d.height));
      complementArea.subtract(area1);
      area1 = complementArea;
    }
    if(operation != NONE){
      g2d.fill(area1);
    }
  }

  /**
   * Sets the operation.
   * @param newOperation The new operation
   */
  public void setOperation(int newOperation){
    operation = newOperation;
    repaint();
  }

  private void jbInit() throws Exception {
    this.setBackground(Color.white);
    this.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
      public void mouseDragged(MouseEvent e) {
        this_mouseDragged(e);
      }
    });
    this.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        this_mousePressed(e);
      }
      public void mouseReleased(MouseEvent e) {
        this_mouseReleased(e);
      }
    });
  }

  void this_mouseDragged(MouseEvent e) {
    Dimension d = getSize();
    int toX=e.getPoint().x, toY=e.getPoint().y;

    if(state == MOVING){
      if(toX > d.width)
        toX = d.width;
      if(toX < 0)
        toX = 0;
      if(toY > d.height)
        toY = d.height;
      if(toY < 0)
        toY = 0;

      curShape.moveTo(toX+offsetX, toY+offsetY);

    }
    repaint();
  }

  void this_mousePressed(MouseEvent e) {

    if(shape1.path.contains(e.getPoint())){
      curShape = shape1;
      state = MOVING;
      offsetX = shape1.upperLeftX() - e.getPoint().x;
      offsetY = shape1.upperLeftY() - e.getPoint().y;
    }
    else if(shape2.path.contains(e.getPoint())){
      curShape = shape2;
      state = MOVING;
      offsetX = shape2.upperLeftX() - e.getPoint().x;
      offsetY = shape2.upperLeftY() - e.getPoint().y;
    }
  }

  void this_mouseReleased(MouseEvent e) {
    curShape = null;
    state = NONE;
  }
}
