import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.applet.*;
import javax.swing.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */

public class VennShape {
  public static final int RECTANGLE = 0, ELLIPSE = 1, STAR = 2, TRIANGLE = 3;
  public GeneralPath path = new GeneralPath();
  private Color shapeColor = Color.white;
  private int type;
  private int upperLeftX = 0;
  private int upperLeftY = 0;
  private int lowerRightX = 0;
  private int lowerRightY = 0;
  private int height = 0;
  private int width = 0;

  public void setColor(Color newColor){
    shapeColor = newColor;
  }

  public Color getColor(){
    return shapeColor;
  }

  public void setType(int newType){
    type = newType;
    makePath(type, upperLeftX, upperLeftY, width, height);
  }

  private void makePath(int pathType, int pathUpperLeftX, int pathUpperLeftY, int pathWidth, int pathHeight) {
    path.reset();
    switch (pathType){
       case RECTANGLE:
        path.moveTo(upperLeftX, upperLeftY);
        path.lineTo(lowerRightX, upperLeftY);
        path.lineTo(lowerRightX, lowerRightY);
        path.lineTo(upperLeftX, lowerRightY);
        path.closePath();
        break;
      case ELLIPSE:
        path = new GeneralPath(new Ellipse2D.Double(upperLeftX, upperLeftY, width, height));
        break;
      case STAR:
        path.moveTo((float)(upperLeftX+.5*width), (float)upperLeftY);
        path.lineTo((float)(upperLeftX+(11.0/14.0)*width), (float)lowerRightY);
        path.lineTo((float)upperLeftX, (float)(upperLeftY+(5.0/14.0)*height));
        path.lineTo((float)lowerRightX, (float)(upperLeftY+(5.0/14.0)*height));
        path.lineTo((float)(upperLeftX+(3.0/14.0)*width), (float)lowerRightY);
        path.closePath();
        break;
      case TRIANGLE:
        path.moveTo(upperLeftX+(width/2), upperLeftY);
        path.lineTo(lowerRightX, lowerRightY);
        path.lineTo(upperLeftX, lowerRightY);
        path.closePath();
        break;
    }
  }

  public VennShape(int newType, int newUpperLeftX, int newUpperLeftY, int newWidth, int newHeight) {
    type = newType;
    upperLeftX = newUpperLeftX;
    upperLeftY = newUpperLeftY;
    lowerRightX = upperLeftX + newWidth;
    lowerRightY = upperLeftY + newHeight;
    width = newWidth;
    height = newHeight;

    makePath(newType, newUpperLeftX, newUpperLeftY, newWidth, newHeight);
  }
    public void moveTo(int newUpperLeftX, int newUpperLeftY){
    upperLeftX = newUpperLeftX;
    upperLeftY = newUpperLeftY;
    lowerRightX = newUpperLeftX+width;
    lowerRightY = newUpperLeftY+height;

    makePath(type, upperLeftX, upperLeftY, width, height);
  }

  public int upperLeftX(){
    return upperLeftX;
  }

  public int upperLeftY(){
    return upperLeftY;
  }

}
