<HTML>
<HEAD>
<TITLE>PHP and Files Example</TITLE>
</HEAD>

<TABLE COLS=2 WIDTH="90%" BGCOLOR="#cceeee">
<TR>
    <TD BGCOLOR="lightblue" colspan=2>
        <h2>A filesystem example</H2>
    </TD>
</TR>
<TR VALIGN=top>
    <TD BGCOLOR="lightblue">
        <TABLE>
            <TR><TD>
            <UL>
    
            <?php  
            //--------------------------------------------------------------------------
            // The usual code required to get the values of variables passed to the page
            // In this case, the variable is the name of the file that is selected.
            //
            if ( isset($_REQUEST['name'])) { $name = $_REQUEST['name']; }
            else                           { $name = ""; }
    
            //--------------------------------------------------------------------------
            // This get a variable which can access the directory specified.
            $handle=opendir("Stuff/");

            //--------------------------------------------------------------------------
            // I extract the names of all of the files in the directory, and put them
            // into an array so I can sort it.
            $files=array();
            while ($file = readdir($handle)) // this function returns the name of the 
                                             // next file in the directory
            {
                $files[count($files)]=$file;
            }
    
            //--------------------------------------------------------------------------
            // Sort the list of filenames.
            sort($files);

            //--------------------------------------------------------------------------
            // Put the list of files on the left part of the page.  Each is a link so
            // that when clicked, it will reload this same page and include one argument
            // to the page--the name of the file to display.
            // Placing the arguments in the URL is another method of passing variables
            // to a script.
            foreach($files as $file) {  // Lists a link for each file
               if($file != "." && $file != ".." ) 
               {
                   // Notice that I do not include the name of this script in the URL
                   // In this case, it assumes I want the same script.
                   print "<LI><A HREF='?name=$file'>$file</A>\n";
               }
            }
            // To be safe, etc., close the directory.
            closedir($handle);
            ?>
            </UL>
            </TD></TR>
        </TABLE>
    </TD>
    <TD>
        <?php  
        
        //--------------------------------------------------------------------------
        // If a filename is passed in, print the contents of the file in the main
        // part of the page.
        if($name) 
        {
            print "<center>The contents of the file <b>$name</b>:</center><p>";

            // The following if checks to make sure the file was opened properly.
            // An earlier version of the program did not do this check, and because
            // the file had not been opened properly, the log files on CSE were
            // filled with error messages, and CSE ran out of disk space in a matter
            // of a few minutes.  Another example of why "Safe Programming" is
            // important.
            if ( $thefile=fopen("Stuff/$name",'r') )  // Open the file
            {
                // The file is read character by character, and then each character 
                // is converted to an HTML tag, if necessary, or just printed.
                // Newer versions of PHP would allow you to read the whole file in
                // in one line, and convert the whole file with another line, and
                // then print the whole file with a third line.  
                print "<pre>";
                $p=fgetc($thefile); // Read file character by character
                $trans = get_html_translation_table(HTML_ENTITIES); 
                while(!feof($thefile)) 
                {
                    print strtr($p,$trans); // Translate the character to HTML if it is special.
                    $p=fgetc($thefile);
                }
                print "</pre>";
            }
            else
            {
               // If something goes wrong, print this message.
               print "The file appears not to exist, or it is not readable";
            }
        }
        ?>
    </TD>
</TR>
</TABLE>

</BODY>
</HTML> 
